@extends('layouts.master')
@section('title', 'Blog')
@section('content')

<!-- Breadcrumb section -->
<div class="site-breadcrumb">
	<div class="container">
		<a href="#"><i class="fa fa-home"></i> Home</a> <i class="fa fa-angle-right"></i>
		<span>Blog</span>
	</div>
</div>
<!-- Breadcrumb section end -->

<!-- Blog page section  -->
<section class="blog-page-section spad pt-0">
	<div class="container">
		<div class="row">
			<div class="col-lg-8 post-list">
				@foreach($data as $row)
				<div class="post-item">
					<div class="post-thumb set-bg" data-setbg="<?php if($row->picture != NULL){ echo url('assets/files/blog/'.$row->picture.'?time='.time()); }else{ echo url('assets/frontend/img/no-picture.png?time='.time()); } ?>"></div>
					<div class="post-content">
						<h3><a href="{{ url('blog') }}/{{ $row->slug }}">{{ $row->title }}</a></h3>
						<div class="post-meta">
							<span><i class="fa fa-calendar-o"></i> {{ $row->updated_at != NULL ? Helper::tgl_indo($row->updated_at) : Helper::tgl_indo($row->created_at) }}</span>
							<span><i class="fa fa-user"></i> {{ $row->nama_author }}</span>
						</div>
						<p><?php echo substr($row->content, 0, 150); ?>... <a href="{{ url('blog') }}/{{ $row->slug }}" style="font-size: 14px;">Read more</a></p>
					</div>
				</div>
				@endforeach
				<ul class="site-pageination">
					{{ $data->links('pagination.default') }}
				</ul>
			</div>
			<!-- sidebar -->
			@include('layouts.sidebar')
		</div>
	</div>
</section>
<!-- Blog page section end -->

@endsection
